# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['examples',
 'plugins',
 'sanic_plugin_toolkit',
 'sanic_plugin_toolkit.plugins',
 'tests']

package_data = \
{'': ['*'], 'tests': ['static/*']}

install_requires = \
['sanic>=21.3.1,<22', 'setuptools>=40.8']

entry_points = \
{'sanic_plugins': ['Contextualize = '
                   'sanic_plugin_toolkit.plugins.contextualize:instance']}

setup_kwargs = {
    'name': 'sanic plugin toolkit',
    'version': '1.0.1',
    'description': 'The all-in-one toolkit for creating powerful Sanic Plugins',
    'long_description': 'Sanic Plugin Toolkit\n====================\n\n|Build Status| |Latest Version| |Supported Python versions| |License|\n\nWelcome to the Sanic Plugin Toolkit.\n\nThe Sanic Plugin Toolkit (SPTK) is a lightweight python library aimed at making it as simple as possible to build\nplugins for the Sanic Async HTTP Server.\n\nThe SPTK provides a `SanicPlugin` python base object that your plugin can build upon. It is set up with all of the basic\nfunctionality that the majority of Sanic Plugins will need.\n\nA SPTK Sanic Plugin is implemented in a similar way to Sanic Blueprints. You can use convenience decorators to set up all\nof the routes, middleware, exception handlers, and listeners your plugin uses in the same way you would a blueprint,\nand any Application developer can import your plugin and register it into their application.\n\nThe Sanic Plugin Toolkit is more than just a Blueprints-like system for Plugins. It provides an enhanced middleware\nsystem, and manages Context objects.\n\n**Notice:** Please update to SPTK v0.90.1 if you need compatibility with Sanic v21.03+.\n\nThe Enhanced Middleware System\n------------------------------\n\nThe Middleware system in the Sanic Plugin Toolkit both builds upon and extends the native Sanic middleware system.\nRather than simply having two middleware queues (\'request\', and \'response\'), the middleware system in SPF uses five\nadditional queues.\n\n- Request-Pre: These middleware run *before* the application\'s own request middleware.\n- Request-Post: These middleware run *after* the application\'s own request middleware.\n- Response-Pre: These middleware run *before* the application\'s own response middleware.\n- Response-Post: These middleware run *after* the application\'s own response middleware.\n- Cleanup: These middleware run *after* all of the above middleware, and are run after a response is sent, and are run even if response is None.\n\nSo as a plugin developer you can choose whether you need your middleware to be executed before or after the\napplication\'s own middleware.\n\nYou can also assign a priority to each of your plugin\'s middleware so you can more precisely control the order in which\nyour middleware is executed, especially when the application is using multiple plugins.\n\nThe Context Object Manager\n--------------------------\n\nOne feature that many find missing from Sanic is a context object. SPF provides multiple context objects that can be\nused for different purposes.\n\n- A shared context: All plugins registered in the SPF have access to a shared, persistent context object, which anyone can read and write to.\n- A per-request context: All plugins get access to a shared temporary context object anyone can read and write to that is created at the start of a request, and deleted when a request is completed.\n- A per-plugin context: All plugins get their own private persistent context object that only that plugin can read and write to.\n- A per-plugin per-request context: All plugins get a temporary private context object that is created at the start of a request, and deleted when a request is completed.\n\n\nInstallation\n------------\n\nInstall the extension with using pip, or easy\\_install.\n\n.. code:: bash\n\n    $ pip install -U sanic-plugin-toolkit\n\nUsage\n-----\n\nA simple plugin written using the Sanic Plugin Toolkit will look like this:\n\n.. code:: python\n\n    # Source: my_plugin.py\n    from sanic_plugin_toolkit import SanicPlugin\n    from sanic.response import text\n\n    class MyPlugin(SanicPlugin):\n        def __init__(self, *args, **kwargs):\n            super(MyPlugin, self).__init__(*args, **kwargs)\n            # do pre-registration plugin init here.\n            # Note, context objects are not accessible here.\n\n        def on_registered(self, context, reg, *args, **kwargs):\n            # do post-registration plugin init here\n            # We have access to our context and the shared context now.\n            context.my_private_var = "Private variable"\n            shared = context.shared\n            shared.my_shared_var = "Shared variable"\n\n    my_plugin = MyPlugin()\n\n    # You don\'t need to add any parameters to @middleware, for default behaviour\n    # This is completely compatible with native Sanic middleware behaviour\n    @my_plugin.middleware\n    def my_middleware(request)\n        h = request.headers\n        #Do request middleware things here\n\n    #You can tune the middleware priority, and add a context param like this\n    #Priority must be between 0 and 9 (inclusive). 0 is highest priority, 9 the lowest.\n    #If you don\'t specify an \'attach_to\' parameter, it is a \'request\' middleware\n    @my_plugin.middleware(priority=6, with_context=True)\n    def my_middleware2(request, context):\n        context[\'test1\'] = "test"\n        print("Hello world")\n\n    #Add attach_to=\'response\' to make this a response middleware\n    @my_plugin.middleware(attach_to=\'response\', with_context=True)\n    def my_middleware3(request, response, context):\n        # Do response middleware here\n        return response\n\n    #Add relative=\'pre\' to make this a response middleware run _before_ the\n    #application\'s own response middleware\n    @my_plugin.middleware(attach_to=\'response\', relative=\'pre\', with_context=True)\n    def my_middleware4(request, response, context):\n        # Do response middleware here\n        return response\n\n    #Add attach_to=\'cleanup\' to make this run even when the Response is None.\n    #This queue is fired _after_ response is already sent to the client.\n    @my_plugin.middleware(attach_to=\'cleanup\', with_context=True)\n    def my_middleware5(request, context):\n        # Do per-request cleanup here.\n        return None\n\n    #Add your plugin routes here. You can even choose to have your context passed in to the route.\n    @my_plugin.route(\'/test_plugin\', with_context=True)\n    def t1(request, context):\n        words = context[\'test1\']\n        return text(\'from plugin! {}\'.format(words))\n\n\nThe Application developer can use your plugin in their code like this:\n\n.. code:: python\n\n    # Source: app.py\n    from sanic import Sanic\n    from sanic_plugin_toolkit import SanicPluginRealm\n    from sanic.response import text\n    import my_plugin\n\n    app = Sanic(__name__)\n    realm = SanicPluginRealm(app)\n    assoc = realm.register_plugin(my_plugin)\n\n    # ... rest of user app here\n\n\nThere is support for using a config file to define the list of plugins to load when SPF is added to an App.\n\n.. code:: ini\n\n    # Source: sptk.ini\n    [plugins]\n    MyPlugin\n    AnotherPlugin=ExampleArg,False,KWArg1=True,KWArg2=33.3\n\n.. code:: python\n\n    # Source: app.py\n    app = Sanic(__name__)\n    app.config[\'SPTK_LOAD_INI\'] = True\n    app.config[\'SPTK_INI_FILE\'] = \'sptk.ini\'\n    realm = SanicPluginRealm(app)\n\n    # We can get the assoc object from SPF, it is already registered\n    assoc = spf.get_plugin_assoc(\'MyPlugin\')\n\nOr if the developer prefers to do it the old way, (like the Flask way), they can still do it like this:\n\n.. code:: python\n\n    # Source: app.py\n    from sanic import Sanic\n    from sanic.response import text\n    from my_plugin import MyPlugin\n\n    app = Sanic(__name__)\n    # this magically returns your previously initialized instance\n    # from your plugin module, if it is named `my_plugin` or `instance`.\n    assoc = MyPlugin(app)\n\n    # ... rest of user app here\n\nContributing\n------------\n\nQuestions, comments or improvements? Please create an issue on\n`Github <https://github.com/ashleysommer/sanic-plugin-toolkit>`__\n\nCredits\n-------\n\nAshley Sommer `ashleysommer@gmail.com <ashleysommer@gmail.com>`__\n\n\n.. |Build Status| image:: https://api.travis-ci.org/ashleysommer/sanic-plugin-toolkit.svg?branch=master\n   :target: https://travis-ci.org/ashleysommer/sanic-plugin-toolkit\n\n.. |Latest Version| image:: https://img.shields.io/pypi/v/sanic-plugin-toolkit.svg\n   :target: https://pypi.python.org/pypi/sanic-plugin-toolkit/\n\n.. |Supported Python versions| image:: https://img.shields.io/pypi/pyversions/sanic-plugin-toolkit.svg\n   :target: https://img.shields.io/pypi/pyversions/sanic-plugin-toolkit.svg\n\n.. |License| image:: http://img.shields.io/:license-mit-blue.svg\n   :target: https://pypi.python.org/pypi/sanic-plugin-toolkit/\n',
    'author': 'Ashley Sommer',
    'author_email': 'ashleysommer@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/ashleysommer/sanicplugintoolkit',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
